clear all;
close all;

format long;

modelMech_file = strcat('strip_scale_rad_p783_num_domy_6_part225.mph');
modelData_file = 'strip_scale_rad_p783_num_domy_6_part2.mat';
% modelData_file = 'strip_scale_rad_p783_num_domy_6.mat';

Eval.mech_mode_number_min = 26;
Eval.mech_mode_number_max = 28;

load(modelData_file);
%% load mechanical model
modelMech = mphload(modelMech_file);
fig = figure(1);
clf;
% view(0,90)
% box on
% mphgeom(modelMech)
%% plot mechanical mode

rot = modelMech.result.dataset.create('sec1', 'Sector3D');
rot.set('method', 'pointdir');
rot.set('pdpoint', {num2str(geom.mech.amech/2,'%10.9e') '0' '0'});
rot.set('include', 'manual');
rot.set('sectorsinclude', 1);
rot.set('startsector', 5);
rot.set('sectors', 6);

% Generate data for an array
% modelMech.result.dataset.create('arr1', 'Array3D');
% modelMech.result.dataset('arr1').set('data', 'sec1');
% modelMech.result.dataset('arr1').set('fullsize', [2 1 1]);
% modelMech.result.dataset('arr1').set('displmethod', 'manual');
% modelMech.result.dataset('arr1').set('floquetper', true);
% modelMech.result.dataset('arr1').set('wavevector', {...
%     num2str(sqrt(Eval_mech.kx(25)^2 + Eval_mech.ky(25)^2),'%10.9e') '0' '0'});
% modelMech.result.dataset('arr1').set('displ', [geom.mech.amech 0 0]);

modelMech.result.create('pg2', 3);
modelMech.result('pg2').set('data', 'sec1'); % For an unit cell
% modelMech.result('pg2').set('data', 'arr1'); % For an array
modelMech.result('pg2').create('surf1', 'Surface');
modelMech.result('pg2').label('Mode Shape2 (solid)');
% modelMech.result('pg2').feature('surf1').create('def', 'Deform');
% modelMech.result('pg2').feature('surf1').feature('def').set('expr', {'u' 'v' 'w'});
% modelMech.result('pg2').feature('surf1').feature('def').set('descr', 'Displacement field (Material)');
modelMech.result('pg2').set('edges', 'off');

% Plot total energy density
modelMech.result('pg2').feature('surf1').set('expr', {'log(solid.Wh)'});
modelMech.result('pg2').feature('surf1').set('colortable', 'HeatCameraLight');
modelMech.result('pg2').feature('surf1').set('rangecoloractive', 'on');
modelMech.result('pg2').feature('surf1').set('rangecolormin', '49');
modelMech.result('pg2').feature('surf1').set('rangecolormax', '54');

% Plot disp_rms
% modelMech.result('pg2').feature('surf1').set('expr', {'solid.disp_rms'});
% modelMech.result('pg2').feature('surf1').set('colortable', 'HeatCameraLight');
% modelMech.result('pg2').feature('surf1').set('rangecoloractive', 'on');
% modelMech.result('pg2').feature('surf1').set('rangecolormin', '0');
% modelMech.result('pg2').feature('surf1').set('rangecolormax', '4');

% Plot divergence of displacement
% modelMech.result('pg2').feature('surf1').set('expr', {'solid.gradUxX+solid.gradUyY+solid.gradUzZ'});
% modelMech.result('pg2').feature('surf1').set('rangecolormin', '-80000');
% modelMech.result('pg2').feature('surf1').set('rangecolormax', '80000');

% Plot x displacement
% modelMech.result('pg2').feature('surf1').set('expr', {'real((u+v*sqrt(3))/2)'});
% modelMech.result('pg2').feature('surf1').set('colortable', 'Wave');
% modelMech.result('pg2').feature('surf1').set('rangecoloractive', 'on');
% modelMech.result('pg2').feature('surf1').set('rangecolormin', '-4');
% modelMech.result('pg2').feature('surf1').set('rangecolormax', '4');
 
view(0,90)
box on

for i=Eval.mech_mode_number_min:Eval.mech_mode_number_max
    modelMech.result('pg2').set('looplevel', {num2str(i)});
    mphplot(modelMech, 'pg2','rangenum',1);

    view(0,90)
    box on

    % Saving .fig file
    savefig(fig, strcat('ene_den_k_25of45_mode_', num2str(i), '.fig'))
end
